<?php

namespace Comitium5\DesignerBundle\Form\Type\Extension;

use Comitium5\DesignerBundle\Entity\Asset;
use Comitium5\DesignerBundle\Form\Type\AssetType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class AssetTypeExtension
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Type\Extension
 */
class AssetTypeExtension extends AbstractTypeExtension
{
    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver
            ->setDefined(array(
                'asset_type',
                'mime_types',
                'asset_class',
                'from_library',
                'allow_external',
            ))
            ->setDefaults(array(
                'asset_type' => null,
                'asset_class' => Asset::class,
                'mime_types' => null,
                'multiple' => false,
                'from_library' => true,
                'allow_external' => true,
            ));
    }

    /**
     * @param FormView      $view
     * @param FormInterface $form
     * @param array         $options
     */
    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['asset_type'] = $options['asset_type'];
        $view->vars['mime_types'] = $options['mime_types'];
        $view->vars['multiple'] = $options['multiple'];
        $view->vars['from_library'] = $options['from_library'];
        $view->vars['allow_external'] = $options['allow_external'];
    }

    /**
     * @return string
     */
    public function getExtendedType()
    {
        return AssetType::class;
    }
}
