<?php

namespace Comitium5\DesignerBundle\Form\Extension;

use Comitium5\DesignerBundle\Form\Type\CKEditor\CKEditorType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class CKEditorExtension
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Extension
 */
class CKEditorExtension extends AbstractTypeExtension
{
    /**
     * @var array
     */
    private $config;

    /**
     * @param array $config
     */
    public function __construct(array $config)
    {
        $this->config = $config;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver
            ->setDefaults(array(
                'template' => $this->config['default_template'],
                'style'    => $this->config['default_style'],
                'toolbar'  => $this->config['default_toolbar'],
                'config'   => $this->config['default_config'],
                'skin'     => $this->config["configs"]["default"]['skin'],
            ))
            ->setRequired(self::getExtensionParameters());
    }

    public static function getExtensionParameters()
    {
        return array('template', 'toolbar', 'style', 'config');
    }

    /**
     * Returns the name of the type being extended.
     *
     * @return string The name of the type being extended
     */
    public function getExtendedType()
    {
        return CKEditorType::class;
    }
}
