<?php

namespace Comitium5\DesignerBundle\Factory\Pagination;

use Comitium5\DesignerBundle\Model\Interfaces\Pagination\PaginationInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Pagination\PaginatorInterface;

/**
 * Class PaginationFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Pagination
 */
class KnpPaginationFactory
{
    /**
     * @param PaginatorInterface $paginatorService
     * @param $response
     * @param array $options
     *
     * @return PaginationInterface
     */
    public static function createForApi(
        PaginatorInterface $paginatorService,
        array $response,
        array $options = []
    ): PaginationInterface {
        $pagination = $paginatorService->paginate(
            $response["results"],
            $response["page"],
            $response["limit"],
            $options
        );

        $pagination
            ->setItems($response["results"])
            ->setTotalItemCount($response["total"]);

        return $pagination;
    }
}
