<?php

namespace Comitium5\DesignerBundle\Factory\Locale;

use Comitium5\DesignerBundle\Entity\Locale;
use Comitium5\DesignerBundle\Factory\NormalizerFactoryInterface;

/**
 * Class LocaleFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Locale
 */
class LocaleFactory implements NormalizerFactoryInterface
{
    /**
     * @param array $locale
     *
     * @return Locale
     */
    public function create(array $locale)
    {
        $entity = new Locale();

        $entity
            ->setId($locale["id"])
            ->setName($locale["name"])
            ->setCode($locale["code"])
            ->setIsDefault($locale["isDefault"] ?? false)
        ;

        return $entity;
    }
}
