<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Widget\WidgetFavoriteInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Widget\WidgetInterface;

/**
 * Class WidgetFavorite
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class WidgetFavorite implements WidgetFavoriteInterface
{
    /**
     * @var WidgetInterface
     */
    private $widget;

    /**
     * @var int
     */
    private $user;

    /**
     * WidgetFavorite constructor.
     *
     * @param WidgetInterface $widget
     * @param int $user
     */
    public function __construct(WidgetInterface $widget, int $user)
    {
        $this->widget = $widget;
        $this->user   = $user;
    }

    /**
     * @param WidgetInterface $widget
     * @return $this
     */
    public function setWidget(WidgetInterface $widget)
    {
        $this->widget = $widget;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getWidget()
    {
        return $this->widget;
    }

    /**
     * @param int $user
     *
     * @return $this|mixed
     */
    public function setUser(int $user)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return int
     */
    public function getUser(): int
    {
        return $this->user;
    }
}
