<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Template\TemplateGroupInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Template\TemplateInterface;
use Comitium5\DesignerBundle\Model\Traits\DateTimeTrait;
use Comitium5\DesignerBundle\Model\Traits\EnabledTrait;
use Comitium5\DesignerBundle\Model\Traits\HierarchicalTrait;
use SebastianBergmann\CodeCoverage\Report\Text;

/**
 * Class TemplateGroup
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class TemplateGroup extends AbstractEntity implements TemplateGroupInterface
{
    use DateTimeTrait, EnabledTrait, HierarchicalTrait;

    /**
     * @var string
     */
    private $name;
    /**
     * @var text
     */
    private $description;

    /**
     * @var TemplateInterface
     */
    private $template;

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     *
     * @return mixed
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param mixed $description
     *
     * @return mixed
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * @param mixed $template
     */
    public function setTemplate(TemplateInterface $template)
    {
        $this->template = $template;
    }
}
