<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Site\SiteInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Subsite\SubsiteInterface;
use Comitium5\DesignerBundle\Model\Traits\DateTimeTrait;
use Comitium5\DesignerBundle\Model\Traits\IdentifiableTrait;

/**
 * Class Subsite
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class Subsite implements SubsiteInterface
{
    use IdentifiableTrait, DateTimeTrait;

    private $locale;

    private $name;

    private $description;

    private $domain;

    private $acronym;

    private $isDefault;

    private $localeDomains;

    private $color;

    private $site;

    private $config;

    /**
     * @return string
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * @param string $locale
     *
     * @return $this|Subsite
     */
    public function setLocale($locale)
    {
        $this->locale = $locale;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return $this|Subsite
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     *
     * @return $this|Subsite
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * @param string $domain
     *
     * @return $this|Subsite
     */
    public function setDomain($domain)
    {
        $this->domain = $domain;

        return $this;
    }

    /**
     * @return string
     */
    public function getAcronym()
    {
        return $this->acronym;
    }

    /**
     * @param string $acronym
     *
     * @return $this|Subsite
     */
    public function setAcronym($acronym)
    {
        $this->acronym = $acronym;

        return $this;
    }

    /**
     * @return bool
     */
    public function isDefault()
    {
        return $this->isDefault;
    }

    /**
     * @param bool $isDefault
     *
     * @return $this|Subsite
     */
    public function setIsDefault($isDefault)
    {
        $this->isDefault = $isDefault;

        return $this;
    }

    /**
     * @return array
     */
    public function getLocaleDomains(): array
    {
        return $this->localeDomains;
    }

    /**
     * @param array $localeDomains
     *
     * @return $this
     */
    public function setLocaleDomains(array $localeDomains)
    {
        $this->localeDomains = $localeDomains;

        return $this;
    }

    /**
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * @param string $color
     *
     * @return $this|Subsite
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * @return SiteInterface
     */
    public function getSite()
    {
        return $this->site;
    }

    /**
     * @param $site
     *
     * @return $this|Subsite
     */
    public function setSite($site)
    {
        $this->site = $site;

        return $this;
    }

    /**
     * @return array
     */
    public function getConfig(): array
    {
        return $this->config;
    }

    /**
     * @param array $config
     *
     * @return $this|Subsite
     */
    public function setConfig(array $config)
    {
        $this->config = $config;

        return $this;
    }
}
