<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\ContentType;
use Comitium5\DesignerBundle\Model\Interfaces\Page\DesignerPageInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageInterface;
use Comitium5\DesignerBundle\Model\PageType;
use Comitium5\DesignerBundle\Model\Traits\DateTimeTrait;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutPageCollectionTrait;
use Comitium5\DesignerBundle\Model\Traits\PublishDateTrait;
use Comitium5\DesignerBundle\Model\Traits\Template\TemplateRelationTrait;
use Comitium5\DesignerBundle\Model\Traits\View\ViewCollectionTrait;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Page
 *
 * @author Fernando Pradas <fernando@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class Page extends AbstractSerializeEntity implements PageInterface
{
	use DateTimeTrait,
        TemplateRelationTrait,
        PublishDateTrait,
        LayoutPageCollectionTrait,
        ViewCollectionTrait;

    const FILE_FOLDER = 'Pages';
    const TMP_FOLDER = 'tmp';
    const FILE_NAME = 'page%d.html.twig';

    /**
     * @var string
     */
    private $name;

    /**
     * @var int
     */
    private $type;

    /**
     * @var int
     */
    private $originId;

    /**
     * Page constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->name        = "";
        $this->layoutPages = new ArrayCollection();
        $this->type        = PageType::CMS_STANDARD_PAGE;
        $this->views       = new ArrayCollection();
    }

    /**
     * {@inheritDoc}
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * {@inheritDoc}
     * @return Page
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @return int
     */
    public static function getSelfContentType()
    {
        return ContentType::PAGES;
    }

    /**
     * @param bool $temporary
     * @return string
     */
    public function getFilePath($temporary = false)
    {
        $path = self::FILE_FOLDER.DIRECTORY_SEPARATOR;

        if ($temporary) {
            $path .= self::TMP_FOLDER.DIRECTORY_SEPARATOR;
        }

        return $path.sprintf(
            self::FILE_NAME, $this->getOriginId()
        );
    }

    /**
     * @return bool|mixed
     */
    public function allowedToInsertResourcesOnTwigTemplates()
    {
        return $this->type !== PageType::AMP_PAGE;
    }

    /**
     * @return int
     */
    public function getOriginId(): int
    {
        return $this->originId;
    }

    /**
     * @param $originId
     *
     * @return $this
     */
    public function setOriginId($originId): self
    {
        $this->originId = $originId;

        return $this;
    }

    /**
     * @param string $name
     *
     * @return $this|DesignerPageInterface
     */
    public function setName(string $name): DesignerPageInterface
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return (string) $this->name;
    }
}
