<?php

namespace Comitium5\DesignerBundle\Entity;


use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageWidgetInterface;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutPageRelationTrait;
use Comitium5\DesignerBundle\Model\Traits\SortableTrait;
use Comitium5\DesignerBundle\Model\Traits\TmpIdentifierTrait;
use Comitium5\DesignerBundle\Model\Traits\Widget\WidgetRelationTrait;

/**
 * Class LayoutPageWidget
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class LayoutPageWidget extends AbstractSerializeEntity implements LayoutPageWidgetInterface
{
    use SortableTrait,
        LayoutPageRelationTrait,
        WidgetRelationTrait,
        TmpIdentifierTrait
        ;

    /**
     * @var \DateTime
     */
    private $startAt;

    /**
     * @var \DateTime
     */
    private $endAt;

    /**
     * @var array
     */
    private $parameters = [];

    /**
     * @return \DateTime
     */
    public function getStartAt()
    {
        return $this->startAt;
    }

    /**
     * @param  \DateTime $startAt
     * @return self
     */
    public function setStartAt($startAt)
    {
        $this->startAt = $startAt;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndAt()
    {
        return $this->endAt;
    }

    /**
     * @param  \DateTime $endAt
     * @return self
     */
    public function setEndAt($endAt)
    {
        $this->endAt = $endAt;

        return $this;
    }

    /**
     * @return array
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    /**
     * @param array $parameters
     *
     * @return self
     */
    public function setParameters(array $parameters)
    {
        $this->parameters = $parameters;

        return $this;
    }
}
