<?php

namespace Comitium5\DesignerBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class Comitium5DesignerExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('classes.yml');
        $loader->load('services.yml');
        $loader->load('managers.yml');
        $loader->load('repositories.yml');
        $loader->load('helpers.yml');
        $loader->load('factories.yml');
        $loader->load('loaders.yml');
        $loader->load('providers.yml');
        $loader->load('forms.yml');
        $loader->load('resolvers.yml');
        $loader->load('providers.yml');
        $loader->load('builders.yml');

        foreach ($config as $key => $value) {
            $container->setParameter($this->getAlias().".".$key, $value);
        }
    }
}
