<?php

namespace Comitium5\DesignerBundle\DataFixtures\ORM\Widget;

use Comitium5\DesignerBundle\DataFixtures\Abstracts\AbstractFixture;
use Comitium5\DesignerBundle\Entity\WidgetGroup;
use Doctrine\Common\Persistence\ObjectManager;

/**
 * Class WidgetGroupFixtures
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\DataFixtures\ORM\Widget
 */
class WidgetGroupFixtures extends AbstractFixture
{
    /**
     * @param ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->widgetGroups() as $widgetGroup) {
            $entity = new WidgetGroup();

            $entity
                ->setName($widgetGroup["name"])
                ->setDescription($widgetGroup["description"])
                ->setCreatedAt($widgetGroup["createdAt"])
            ;

            $manager->persist($entity);

            $this->setReference($widgetGroup["reference"], $entity);
        }

        $manager->flush();
    }

    /**
     * @return array[]
     */
    private function widgetGroups()
    {
        return [
            [
                "name" => "General",
                "description" => "General widgets",
                "createdAt" => new \DateTime(),
                "reference" => "widget-group-general"
            ],
            [
                "name" => "CMS",
                "description" => "CMS widgets",
                "createdAt" => new \DateTime(),
                "reference" => "widget-group-cms"
            ],
        ];
    }
}
