<?php

namespace Comitium5\DesignerBundle\Controller\Search\Suggest;

use Comitium5\DesignerBundle\Adapter\Search\ExternalDbClient;
use Comitium5\DesignerBundle\Repository\Search\ExternalDbRepository;
use Comitium5\DesignerBundle\UseCase\Search\ExternalDbSuggestSearchUseCase;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class ExternalDbSuggestController
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\Controller\Search\Suggest
 */
class ExternalDbSuggestController extends Controller
{
    /**
     * @param Request $request
     *
     * @return JsonResponse
     * @throws \Exception
     */
    public function __invoke(Request $request): JsonResponse
    {
        $useCase = new ExternalDbSuggestSearchUseCase(
            new ExternalDbRepository(
                new ExternalDbClient(
                    base64_decode($request->get("conn"))
                )
            ),
            base64_decode($request->get("query")),
            $request->get("term")
        );

        return $useCase();
    }
}