<?php

namespace Comitium5\DesignerBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class CRUDController
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Controller
 */
abstract class CRUDController extends BaseController
{
    /**
     * @param  Request $request
     * @return mixed
     */
    abstract public function listAction(Request $request);

    /**
     * @param  Request $request
     * @return mixed
     */
    abstract public function createAction(Request $request);

    /**
     * @param  Request $request
     * @return mixed
     */
    abstract public function editAction(Request $request);

    /**
     * @param  Request $request
     * @return mixed
     */
    abstract public function deleteAction(Request $request);

    /**
     * @param $template
     * @param  null     $maxAge
     * @param  null     $sharedAge
     * @param  null     $private
     * @return Response
     */
    public function indexAction($template, $maxAge = null, $sharedAge = null, $private = null, $params = [])
    {
        $response = $this->render($template, $params);

        if ($maxAge) {
            $response->setMaxAge($maxAge);
        }

        if ($sharedAge) {
            $response->setSharedMaxAge($sharedAge);
        }

        if ($private) {
            $response->setPrivate();
        } elseif ($private === false || (null === $private && ($maxAge || $sharedAge))) {
            $response->setPublic();
        }

        return $response;
    }
}
