
var SpellText = function() {
    this.successClass = "has-success";
    this.warningClass = "has-warning";
    this.iconClass = "input-icon right";
    this.spellchecker = null;
    this.blocked = false;
    this.bindFunctions();
};

SpellText.prototype.bindFunctions = function() {
    var _this = this;

    $('[data-action="spell_text"]').each(function(){
        var _self = $(this);
        var button = _self.find("button");
        var input = _self.find("input:text");
        var textarea = _self.find("textarea");

        button.on("click", function(){

            if (input.length > 0) {

                var val = $.trim(input.val());

                if (val.length > 0) {
                    _this.initSpellChecker(_self, input, true, function(){
                        _this.blocked = false;
                    });
                } else {
                    _this.resetResults(_self);
                }
            }

            if (textarea.length > 0) {

                var textAreaVal = $.trim(textarea.val());

                if (textAreaVal.length > 0) {
                    _this.initSpellChecker(_self, input, true, function(){
                        _this.blocked = false;
                    });
                } else {
                    _this.resetResults(_self);
                }
            }
        });

        input.on("blur", function(){

            var val = $.trim($(this).val());

            if (val.length > 0) {
                _this.initSpellChecker(_self, input, false, function(){
                    _this.blocked = false;
                });
            } else {
                _this.resetResults(_self);
            }
        });

        textarea.on("blur", function(){

            var val = $.trim($(this).val());

            if (val.length > 0) {
                _this.initSpellChecker(_self, textarea, false, function(){
                    _this.blocked = false;
                });
            } else {
                _this.resetResults(_self);
            }
        });
    });
};

SpellText.prototype.displayResult = function(input, state) {

    this.resetResults(input);

    var group = input.find(".input-group");
    var iconError = input.find('i.fa-warning');
    var iconSuccess = input.find('i.fa-check');

    group.addClass(this.iconClass);

    if (state == "success") {
        iconSuccess.show();
    } else {
        iconError.show();
    }

    input.addClass(state == "success" ? this.successClass : this.warningClass);
};

SpellText.prototype.resetResults = function(input) {
    input.find('i.fa-warning').hide();
    input.find('i.fa-check').hide();
    input.removeClass(this.successClass +" "+this.warningClass);
};

SpellText.prototype.initSpellChecker = function(parent, input, showPopover, callBack) {

    var _this = this;

    if (_this.blocked === true) {
        return false;
    }

    _this.blocked = true;

    var locale = input.data("locale");

    if (this.spellchecker) {
        this.destroypellChecker(input);
    }

    this.spellchecker = new $.SpellChecker(input, {
        lang: locale,
        parser: 'text',
        webservice: {
            path: '/bundles/core/webservices/php/SpellChecker.php',
            driver: 'pspell'
        },
        suggestBox: {
            position: 'below'
        },
        incorrectWords: {
            position: function(container) {
                this.after(container);
            }
        }
    });

    this.spellchecker.on('check.success', function() {
        _this.displayResult(parent, "success");
    });

    this.spellchecker.on('check.fail', function() {
        _this.displayResult(parent, "error");

        if (showPopover) {
            if (input.data('popover')) {
                return;
            }

            input.popover({
                    trigger: 'manual',
                    placement: 'bottom',
                    title: Translator.trans("common.spell.popover.title")+ " " + '<a href="#" class="close"></a>',
                    html: true,
                    content: input.next()
                })
                .popover('show');

            _this.showPopover(parent,input);
        } else {
            _this.destroypellChecker(input);
        }

    });

    this.spellchecker.on('replace.word', function(incorrectWords) {
        _this.showPopover(parent,input);
    });

    this.spellchecker.check(input.val(), function(){
        callBack.call();
    });
};

SpellText.prototype.showPopover = function(parent,input) {
    var _this = this;

    $('.popover').hide().find('.popover-content').each(function(){
        if ($(this).find('a').length) {
            $(this).parents('.popover').show();
            $(this).parents('.popover').find(".close").on("click", function(e){
                e.preventDefault();
                //input.popover('destroy', "hide");
                _this.destroypellChecker(input);
            });
            return false;
        } else {
            _this.displayResult(parent, "success");
        }
    });
};

SpellText.prototype.destroypellChecker = function destroy(field) {
    this.spellchecker.destroy();
    this.spellchecker = null;
    field.popover('destroy');
};
