var Communications = (function () {
    var defaultOptions = {
        tabSelector: "[data-tab]",
        contentTabSelector: "[data-tab-content]",
        tabActiveClass: "active"
    };

    var resolveOptions = function (options) {
        defaultOptions = Object.assign(defaultOptions, options);
    };

    var bindLocaleTabs = function () {
        $(defaultOptions.tabSelector).on("click", function () {
            var $this = $(this);

            disableTabs();
            disableContentTabs();

            $this.addClass(defaultOptions.tabActiveClass);

            $(defaultOptions.contentTabSelector.replace("]", "='"+$this.data("tab")+"']")).addClass(defaultOptions.tabActiveClass);
        });
    };

    var disableTabs = function () {
        $(defaultOptions.tabSelector).each(function () {
            $(this).removeClass(defaultOptions.tabActiveClass);
        });
    };

    var disableContentTabs = function () {
        $(defaultOptions.contentTabSelector).each(function () {
            $(this).removeClass(defaultOptions.tabActiveClass);
        });
    };

    var initLocaleTabs = function () {
        $(defaultOptions.tabSelector+":first").addClass(defaultOptions.tabActiveClass);
        $(defaultOptions.contentTabSelector+":first").addClass(defaultOptions.tabActiveClass);
    };

    return {
        bindForm: function (options) {
            resolveOptions(options);
            initLocaleTabs();
            bindLocaleTabs();
        }
    };
})();
