var ContentTypeManager = (function(){
    function ContentTypeManager() {
        this.container = '#sites-table-container';
    }

    ContentTypeManager.prototype.init = function() {
        var _self = this;
        _self.initCheckboxes();

        Pagination.onChange.add(function() {
            _self.initSwitch(_self.container);
        });
    };

    ContentTypeManager.prototype.initCheckboxes = function() {
        $(document).on('click','[data-action="enable-article-type"]', function() {

            var node  = $(this).find('[type="checkbox"]');
            var id    = node.data('id');
            var state = Number(node.is(':checked'));

            $.ajax({
                url: Routing.generate(
                    'article_type_switch_enabled', {
                        id: id,
                        state: state
                    }, true)
                ,
                method: 'POST',
                success: function(response) {
                    if (response.updated) {
                        showToastrNotification('success',Translator.trans( state ? 'articleType.messages.enabled_success' : 'articleType.messages.disabled_success'));
                    }
                },
                error: function() {
                    showToastrNotification('error',Translator.trans('articleType.messages.generic_error'));
                }
            });
        });
    };

    ContentTypeManager.prototype.initSwitch = function(element) {
        // Switch
        $(element).find('[type="checkbox"]').each(function () {
            $(this).bootstrapSwitch();
        });
    };

    return ContentTypeManager;

}());