var FormEditValidation = function () {

    function bindFunction() {

        $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {
            e.target // newly activated tab
            e.relatedTarget // previous active tab
            if(FormEditValidation.form.valid() === false){
                return false;
            }
        });

        var error = $('.alert-danger', FormEditValidation.form);
        var success = $('.alert-success', FormEditValidation.form);
        return {
            onfocusout: false,
            doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            errorPlacement: function (error, element) { // render error placement for each input type
                if( element.parents('.input-daterange-container:first').length > 0 )
                {
                    if( !element.parents('.input-daterange-container:first').next().hasClass('help-block-error') )
                    {
                        error.insertAfter(element.parents('.input-daterange-container:first'));
                    }
                }
                else if( element.parents('.radio-list:first').length > 0)
                {
                    if( !element.parents('.radio-list:first').next().hasClass('help-block-error') )
                    {
                        error.insertAfter(element.parents('.radio-list:first'));
                    }
                }
                else
                {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }

                //if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                //    error.insertAfter("#form_gender_error");
                //} else if (element.attr("name") == "payment[]") { // for uniform radio buttons, insert the after the given container
                //    error.insertAfter("#form_payment_error");
                //} else {
                //    error.insertAfter(element); // for other inputs, just perform default behavior
                //}
            },

            invalidHandler: function (event, validator) { //display error alert on form submit
                success.hide();
                error.show();
                Metronic.scrollTo(error, -200);
            },

            highlight: function (element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                    .closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                if (label.attr("for") == "gender" || label.attr("for") == "payment[]") { // for checkboxes and radio buttons, no need to show OK icon
                    label
                        .closest('.form-group').removeClass('has-error').addClass('has-success');
                    label.remove(); // remove error label here
                } else { // display success icon for other inputs
                    label
                        .addClass('valid') // mark the current input as valid and display OK icon
                        .closest('.form-group').removeClass('has-error').addClass('has-success'); // set success class to the control group
                }
            },
            submitHandler: function(form) {
                var success = true;

                $.each($(form).serializeArray(), function(i, f) {
                    var field = $('[name="'+f.name+'"]');

                    if (!field.valid()) {
                        var tab = field.parents('.tab-pane');
                        var tabId = tab.parents('.tab-pane').length ? tab.parents('.tab-pane').attr('id') : tab.attr('id');

                        if (tabId) {
                            $('[href="#'+tabId+'"]').tab('show');

                        }
                        success = false;
                    }

                });

                if (!success) {
                   return false;
                }

                $(form).find('button[type="submit"]').prop('disabled', true);

                form.submit();
            }
        };
    }

    return {
        form: null,
        init: function () {
            if (this.form !== null && this.form.is('form')) {
                var options = bindFunction();
                this.form.validate(options);
            }

            $.validator.addMethod("maxlength", function(value, element) {

                var max = parseInt($(element).attr('maxlength'));

                if (max > 0) {
                    var value = $(element).val().trim();
                    var text = $(element).is('textarea') ? value.replace( /<.*?>|\n/g, '' ) : value;

                    if (text.length > max) {
                        return false;
                    }
                }

                return true;
            });
        },
        setForm: function (form) {
            this.form = form;
        }
    };

}();
