<?php

namespace Comitium5\DesignerBundle\ValueObjects;

use Comitium5\DesignerBundle\Factory\Search\SearchEntityFactory;

/**
 * Class SearchResultObject
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class SearchResultObject
{
    /**
     * @var SearchEntityObject[]
     */
    private $results;

    /**
     * @var int
     */
    private $page;

    /**
     * @var int
     */
    private $total;

    /**
     * @var int
     */
    private $totalPages;

    /**
     * @var int
     */
    private $limit;

    /**
     * @var GroupByCollection
     */
    private $groupByCollection;

    /**
     * SearchResultObject constructor.
     *
     * @param array $results
     * @param int $page
     * @param int $total
     * @param int $totalPages
     * @param int $limit
     * @param GroupByCollection|null $groupByCollection
     */
    public function __construct(
        array $results,
        int $page,
        int $total,
        int $totalPages,
        int $limit,
        GroupByCollection $groupByCollection = null
    ) {
        $this->results           = [];
        $this->page              = $page;
        $this->total             = $total;
        $this->totalPages        = $totalPages;
        $this->limit             = $limit;
        $this->groupByCollection = $groupByCollection;

        $this->parseResults($results);
    }

    /**
     * @return array|SearchEntityObject[]
     */
    public function getResults(): array
    {
        return $this->results;
    }

    /**
     * @return int
     */
    public function getPage(): int
    {
        return $this->page;
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }

    /**
     * @return int
     */
    public function getTotalPages(): int
    {
        return $this->totalPages;
    }

    /**
     * @return int
     */
    public function getLimit(): int
    {
        return $this->limit;
    }

    /**
     * @return GroupByCollection|null
     */
    public function getGroupByCollection(): ?GroupByCollection
    {
        return $this->groupByCollection;
    }

    /**
     * @param array $results
     */
    protected function parseResults(array $results): void
    {
        $searchEntityFactory = new SearchEntityFactory();

        foreach ($results as $result) {
            $this->results[] = $searchEntityFactory->create($result);
        }
    }
}
