<?php

namespace Comitium5\DesignerBundle\ValueObjects;

use Comitium5\DesignerBundle\Model\Interfaces\Subsite\SubsiteInterface;

/**
 * Class SearchQueryObject
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class SearchQueryObject
{
    /**
     * @var string
     */
    private $term;

    /**
     * @var string
     */
    private $contentType;

    /**
     * @var int
     */
    private $page;

    /**
     * @var int
     */
    private $limit;

    /**
     * @var array
     */
    private $filters;

    /**
     * @var string|null
     */
    private $groupBy;

    /**
     * @var SearchOrderObject
     */
    private $order;

    /**
     * @var SubsiteInterface[]
     */
    private $subsites;

    /**
     * SearchQueryObject constructor.
     *
     * @param string $term
     * @param string $contentType
     * @param int $page
     * @param int $limit
     * @param array $filters
     * @param string|null $groupBy
     * @param SearchOrderObject|null $searchOrderObject
     * @param SubsiteInterface[] $subsites
     */
    public function __construct(
        string $term,
        string $contentType,
        int $page,
        int $limit,
        array $subsites,
        array $filters = [],
        string $groupBy = null,
        SearchOrderObject $searchOrderObject = null
    ) {
        $this->term        = $term;
        $this->contentType = $contentType;
        $this->page        = $page;
        $this->limit       = $limit;
        $this->subsites    = $subsites;
        $this->filters     = $filters;
        $this->groupBy     = $groupBy;
        $this->order       = $searchOrderObject;
    }

    /**
     * @return string
     */
    public function getTerm(): string
    {
        return $this->term;
    }

    /**
     * @return string
     */
    public function getContentType(): string
    {
        return $this->contentType;
    }

    /**
     * @return int
     */
    public function getPage(): int
    {
        return $this->page;
    }

    /**
     * @return int
     */
    public function getLimit(): int
    {
        return $this->limit;
    }

    /**
     * @return SubsiteInterface[]
     */
    public function getSubsites(): array
    {
        return $this->subsites;
    }

    /**
     * @return array
     */
    public function getFilters(): array
    {
        return $this->filters;
    }

    /**
     * @return string|null
     */
    public function getGroupBy(): ?string
    {
        return $this->groupBy;
    }

    /**
     * @return SearchOrderObject|null
     */
    public function getOrder(): ?SearchOrderObject
    {
        return $this->order;
    }
}
