<?php

namespace Comitium5\DesignerBundle\ValueObjects;

/**
 * Class SearchEntityObject
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class SearchEntityObject
{
    /**
     * @var int
     */
    protected $id;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $fullName;

    /**
     * @var \DateTime
     */
    protected $publishDate;

    /**
     * @var \DateTime
     */
    protected $creationDate;

    /**
     * @var string
     */
    protected $permalink;

    /**
     * @var array
     */
    protected $subsite;

    /**
     * @var bool
     */
    protected $searchable;

    /**
     * @var string
     */
    protected $uuid;

    /**
     * @var bool
     */
    protected $indexable;

    /**
     * @var int
     */
    protected $usages;

    /**
     * @var int
     */
    protected $selfContentType;

    /**
     * @var array
     */
    protected $parent;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $contentType;

    /**
     * SearchEntityObject constructor.
     */
    public function __construct()
    {
        $this->usages = 0;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getFullName(): string
    {
        return $this->fullName;
    }

    /**
     * @return \DateTime|null
     */
    public function getPublishDate(): ?\DateTime
    {
        return $this->publishDate;
    }

    /**
     * @return \DateTime|null
     */
    public function getCreationDate(): ?\DateTime
    {
        return $this->publishDate;
    }

    /**
     * @return string
     */
    public function getPermalink(): string
    {
        return $this->permalink;
    }

    /**
     * @return array
     */
    public function getSubsite(): array
    {
        return $this->subsite;
    }

    /**
     * @return int
     */
    public function getUsages(): int
    {
        return $this->usages;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return int|null
     */
    public function getSelfContentType(): ?int
    {
        return $this->selfContentType;
    }

    /**
     * @return array|null
     */
    public function getParent(): ?array
    {
        return $this->parent;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @return string
     */
    public function getContentType(): string
    {
        return $this->contentType;
    }

    /**
     * @return bool
     */
    public function isSearchable(): bool
    {
        return $this->searchable;
    }

    /**
     * @return bool
     */
    public function isIndexable(): bool
    {
        return $this->indexable;
    }

    /**
     * @param int $id
     *
     * @return $this
     */
    public function setId(int $id): SearchEntityObject
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @param string $title
     *
     * @return $this
     */
    public function setTitle(string $title): SearchEntityObject
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @param string $fullName
     *
     * @return $this
     */
    public function setFullName(string $fullName): SearchEntityObject
    {
        $this->fullName = $fullName;

        return $this;
    }

    /**
     * @param string $publishDate
     *
     * @return $this
     */
    public function setPublishDate(string $publishDate): SearchEntityObject
    {
        $date = \DateTime::createFromFormat(\DateTime::ISO8601, $publishDate);

        $this->publishDate = $date === false ? null : $date;

        return $this;
    }

    /**
     * @param string $creationDate
     *
     * @return $this
     */
    public function setCreationDate(string $creationDate): SearchEntityObject
    {
        $date = \DateTime::createFromFormat(\DateTime::ISO8601, $creationDate);

        $this->creationDate = $date === false ? null : $date;

        return $this;
    }

    /**
     * @param string|null $permalink
     *
     * @return $this
     */
    public function setPermalink(?string $permalink): SearchEntityObject
    {
        $this->permalink = $permalink;

        return $this;
    }

    /**
     * @param array $subsite
     *
     * @return $this
     */
    public function setSubsite(array $subsite): SearchEntityObject
    {
        $this->subsite = $subsite;

        return $this;
    }

    /**
     * @param bool $searchable
     *
     * @return $this
     */
    public function setSearchable(bool $searchable): SearchEntityObject
    {
        $this->searchable = $searchable;

        return $this;
    }

    /**
     * @param bool $indexable
     *
     * @return $this
     */
    public function setIndexable(bool $indexable): SearchEntityObject
    {
        $this->indexable = $indexable;

        return $this;
    }

    /**
     * @param int $usages
     *
     * @return $this
     */
    public function setUsages(int $usages): SearchEntityObject
    {
        $this->usages = $usages;

        return $this;
    }

    /**
     * @param string $uuid
     *
     * @return $this
     */
    public function setUuid(string $uuid): SearchEntityObject
    {
        $this->uuid = $uuid;

        return $this;
    }

    /**
     * @param int $selfContentType
     *
     * @return $this
     */
    public function setSelfContentType(int $selfContentType): SearchEntityObject
    {
        $this->selfContentType = $selfContentType;

        return $this;
    }

    /**
     * @param array $parent
     *
     * @return $this
     */
    public function setParent(array $parent): SearchEntityObject
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * @param string $description
     *
     * @return $this
     */
    public function setDescription(string $description): SearchEntityObject
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @param string $contentType
     *
     * @return $this
     */
    public function setContentType(string $contentType): SearchEntityObject
    {
        $this->contentType = $contentType;

        return $this;
    }
}
