<?php

namespace Comitium5\DesignerBundle\ValueObjects\Common;

/**
 * Class ErrorObject
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects\Common
 */
class ErrorObject
{
    /**
     * @var int
     */
    public $errorCode;

    /**
     * @var string
     */
    public $errorMessage;

    /**
     * @var bool
     */
    public $isValid;

    /**
     * ErrorObject constructor.
     *
     * @param int $errorCode
     * @param string $errorMessage
     * @param bool $isValid
     */
    public function __construct(int $errorCode, string $errorMessage, bool $isValid)
    {
        $this->errorCode = $errorCode;
        $this->errorMessage = $errorMessage;
        $this->isValid = $isValid;
    }

    /**
     * @return int
     */
    public function getErrorCode(): int
    {
        return $this->errorCode;
    }

    /**
     * @return string
     */
    public function getErrorMessage(): string
    {
        return $this->errorMessage;
    }

    /**
     * @return bool
     */
    public function isValid(): bool
    {
        return $this->isValid;
    }
}