<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Page;

use Comitium5\DesignerBundle\Entity\Page;
use Comitium5\DesignerBundle\Entity\Template;
use Comitium5\DesignerBundle\Resolver\Page\PageValidationResolver;
use Comitium5\DesignerBundle\Validator\EntityValidator;
use PHPUnit\Framework\TestCase;

/**
 * Class PageValidationResolverTest
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\UseCase\Page
 */
class PageValidationResolverTest extends TestCase
{
    /**
     * @test
     */
    public function PageValidationResolverTest() : void {
        $this->PageValidationResolverValidTest($this->validPage());
        $this->PageValidationResolverInvalidTest($this->invalidPage());
    }

    /**
     * @param Page|null $page
     */
    public function PageValidationResolverValidTest(Page $page = null) : void {

        $resolver = $this->getPageValidationResolver();

        $errorObject = $resolver($page);

        $this->assertTrue($errorObject->isValid());
        $this->assertEmpty($errorObject->getErrorMessage());
    }

    /**
     * @param Page|null $page
     */
    public function PageValidationResolverInvalidTest(Page $page = null) : void {

        $resolver = $this->getPageValidationResolver();
        $errorObject = $resolver($page);

        $this->assertFalse($errorObject->isValid());
        $this->assertNotEmpty($errorObject->getErrorMessage());
    }

    /**
     * @return PageValidationResolver
     */
    private function getPageValidationResolver() : PageValidationResolver {
        return new PageValidationResolver(new EntityValidator());
    }

    /**
     * @return Page
     */
    private function validPage() : Page {
        $page = new Page();
        $page->setTemplate(new Template());

        return $page;
    }

    /**
     * @return Page
     */
    private function invalidPage() : Page {
        $page = new Page();

        return $page;
    }
}