<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Common;

use Comitium5\DesignerBundle\Factory\Common\ErrorPageResponseFactory;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Templating\EngineInterface;

/**
 * Class ErrorPageResolverTest
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\UseCase\Common
 */
class ErrorPageResolverTest extends TestCase
{
    /**
     * @var string
     */
    const TEMPLATE_RESULT = '<div class="container-fluid">
        <div class="text-center">
            <div class="error mx-auto" data-text="404">404</div>
            <p class="lead text-gray-800 mb-5">not found</p>
            <p class="text-gray-500 mb-0">Error</p>
            <a href="/">Back</a>
        </div>
    </div>
    </div>';

    /**
     * @return ErrorPageResponseFactory
     */
    private function getErrorPageResponseFactory(): ErrorPageResponseFactory
    {
        $mock = $this->createMock(EngineInterface::class);
        $mock->method("render")
            ->willReturn(self::TEMPLATE_RESULT);

        return new ErrorPageResponseFactory($mock);
    }

    /**
     * @test
     */
    public function generateErrorPageTest(): void
    {
        $errorPageResolver = $this->getErrorPageResponseFactory();

        $result = $errorPageResolver(404, "not found", "Error");

        $this->assertInstanceOf(Response::class, $result);
        $this->assertEquals(self::TEMPLATE_RESULT, $result->getContent());
    }

}