$(document).ready(function(){

    var bindTagStatus = function() {

        $('.cs_tags td span.status').each(function(i,e) {
            var $tag = $(e);
            $('i', $tag).on('click', function() {

                if(!$tag.data('lock')) {
                    $tag.data('lock', true);
                    var action = ('enabled' === $tag.data('status')) ? 'disable' : 'enable';
                    $.ajax({
                        url: Routing.generate(
                            'cs_cms_tags_set_state', {
                                id: $tag.data('id'),
                                action: action
                            })
                        ,
                        method: 'POST',
                        complete: function() {
                            $tag.data('lock', false);
                        },
                        success: function() {
                            $tag
                                .data('status', (action == 'enable') ? 'enabled' : 'disabled')
                                .find('i')
                                .removeClass('fa-dot-circle-o fa-circle-o')
                                .addClass((action == 'enable') ? 'fa-dot-circle-o' : 'fa-circle-o');

                            showToastrNotification('success',Translator.trans( $tag.data('status') == 'enabled' ? 'cs_tags.messages.enabled' : 'cs_tags.messages.disabled'));
                        }
                    });
                }
            });

        });
    };

    Pagination.onChange.add(bindTagStatus);

    bindTagStatus();
});
