var SocialNetworkCompletion = (function() {

    var defaultOptions = {
        originAssetElement: null,
        targetAssetElement: null,
        targetAssetDropzones: [],
        allowOverrideData: false
    };

    var bindEvents = function(options) {
        defaultOptions = $.extend(defaultOptions, options);

        if (defaultOptions.originAssetElement && defaultOptions.allowOverrideData == true) {
            AssetsHelper.signals.onLibraryAdd.add(function(parentWidget, origObject, destObject){
                if (parentWidget.is(defaultOptions.originAssetElement)) {
                    var id = destObject.data("id-content");
                    defaultOptions.targetAssetElement.val(id);
                    updateDropzones(id);
                }
            });

            AssetsHelper.signals.onNewCreate.add(function(response, parentWidget){
                if (parentWidget.is(defaultOptions.originAssetElement)) {
                    var id = response.metadata.id;
                    defaultOptions.targetAssetElement.val(id);
                    updateDropzones(id);
                }
            });

            AssetsHelper.signals.onLibraryRemove.add(function(parentWidget){
                if (parentWidget.is(defaultOptions.originAssetElement)) {
                    defaultOptions.targetAssetElement.val("");
                    updateDropzones(null);
                }
            });

            AssetsHelper.signals.onNewRemove.add(function(parentWidget){
                if (parentWidget.is(defaultOptions.originAssetElement)) {
                    defaultOptions.targetAssetElement.val("");
                    updateDropzones(null);
                }
            });
        }
    };

    var updateDropzones = function(id) {
        defaultOptions.targetAssetDropzones.forEach(function (dropzone) {
            if (id) {
                AssetsHelper.loadById(dropzone, id);
            } else {
                dropzone
                    .find('[data-action="unselect"]')
                    .trigger('click');
            }
        });
    };

    return {
        init: function(options) {
            bindEvents(options);
        }
    };
})();
