
var Seo = function() {
    this.standard = true;
    this.mode = 'create';
    this.selector = '[data-seo]';
    this.imageSelector = '[data-seo-image]';

    this.bindFunctions();
};

Seo.prototype.bindFunctions = function() {

    var _this = this;

    $('#seo-start').on('click', function(e){

        e.preventDefault();

        var slug = $('[id$=metadata_slug]').val().replace(/(<([^>]+)>)/ig,"");
        var keyWord = $('[id$=metadata_metaTitle]').val().replace(/(<([^>]+)>)/ig,"");

        if (slug.length == 0 || keyWord.length == 0) {
            showToastrNotification('error', Translator.trans('seo.checker.messages.error'));
            return;
        }

        $.ajax({
            url: Routing.generate('cs_core_seo_generate'),
            data: {
                keyWord : $('[id$=metadata_metaTitle]').val().replace(/(<([^>]+)>)/ig,""),
                metaDescription : $('[id$=metadata_metaDescription]').val().replace(/(<([^>]+)>)/ig,""),
                metaKeyWords : $('[id$=metadata_metaKeywords]').val().replace(/(<([^>]+)>)/ig,""),
                slug : $('[id$=metadata_slug]').val().replace(/(<([^>]+)>)/ig,""),
                content : _this.fetchSeoText(),
                imagesTitles: _this.fetchSeoImagesText(),
                url: $('.content-url a').attr('href')
            },
            type: 'json',
            method: 'post',
            beforeSend: function(){
              $('.cs-module-spinner').show();
            },
            complete: function() {
                $('.cs-module-spinner').hide();
                $('.info', $('#seo-bar')).hide();
            },
            success: function(response) {
                _this.printContent(response.html);
                _this.bindToggles();
                _this.setSeoAverageValueToForm(response.average);
            },
            error: function() {
                $('.cs-module-spinner').hide();
                showToastrNotification('error', Translator.trans('seo.checker.messages.error'));
            }
        });
    });
};

Seo.prototype.setSeoAverageValueToForm = function(average) {
    if (average) {
        $('[id$="_seoAverage"]').val(average);
    }
};

Seo.prototype.bindToggles = function() {
    $('.seo-analysis-summary-list h4').on('click', function(){

        var ul = $(this).next();
        var icon = $(this).find('i');

        if (ul.hasClass('open')) {
            ul.removeClass('open');
        } else {
            ul.addClass('open');
        }

        icon.toggleClass('fa-caret-down fa-caret-right');
    });
};

Seo.prototype.fetchSeoText = function() {

    var text  = '';
    var words = [];

    if (this.standard == true) {
        $(this.selector).each(function(){
            var aux = $.trim($(this).val());
            words.push(aux);
        });

        text = words.join(' ');
    }

    if (this.standard == false) {
        text = 'no-standard';
    }


    return text.replace(/(\r\n|\n|\r)/gm,"");
};

Seo.prototype.fetchSeoImagesText = function() {

    var words = [];

    $(this.imageSelector).each(function(){
        var text = $(this).val();
        text.replace(/(<([^>]+)>)/ig,"");
        words.push(text);
    });

    return words;

};

Seo.prototype.printContent = function(data) {
    $.each(data, function(k,v){
        $('#' + k).replaceWith(v);
    });
};

Seo.prototype.setStandard = function(standard) {
    this.standard = standard;
};

Seo.prototype.getStandard = function() {
    return this.standard;
};

Seo.prototype.setMode = function(mode) {
    this.mode = mode;
};

Seo.prototype.getMode = function() {
    return this.mode;
};
