var Polls = (function() {

    var collectionHolder = $('[data-collection="answer"]');

    var addAnswers = function(){
        collectionHolder.collection({
            button_template: '<button class="btn btn-icon-only btn-circle green gf-add-field"><i class="fa fa-plus"></i></button>',
            label: false,
            insert: 'append',
            childrenFilter: '[data-hook="gf-portlet"]',
            insertButtonSelector: '[data-add="answer"]',
            afterCreate: function (e) {

                var current_element = $(e.detail.button).closest('.portlet-sortable');

                current_element.after($(e.detail.element));

                initializeSpinners(e.detail.element);
                var add_button = $(e.detail.element).find('[data-add="answer"]');
                var delete_button = $(e.detail.element).find('.gf-remove-field');
                var collectionHolderData = collectionHolder.data('collection_options');

                add_button.html('<button class="btn btn-icon-only btn-circle green gf-add-field"><i class="fa fa-plus"></i></button>');
                add_button.find('button').on('click', collectionHolderData.onClick);
                delete_button.on('click', removeAnswer);
                addAnswerLang($(e.detail.element).find('[data-collection="answer-lang"]'));
                $(e.detail.element).find('button[data-add="answer-lang"]').trigger('click');
            },
            iterateAll: function (index, element) {
                $(element).find('.gf-remove-field').on('click', removeAnswer);
            }
        });
    };

    var addAnswerLang = function(selector){
        selector.collection({
            button_template: '<button data-add="answer-lang" class="hidden"></button>',
            label: false,
            insert: 'append',
            childrenFilter: '[data-type="answer-lang"]',
            insertButtonSelector: selector.find('[data-add="answer-lang"]')
        });
    };

    var removeAnswer = function(){

        if(Polls.validateDeletion()){
            $(this).closest('[data-hook="gf-portlet"]').fadeOut(function(){
                $(this).remove();
            })
        }else{
            showToastrNotification('error',Translator.trans('cms_polls.polls.messages.cant_delete_last_answer'));
        }

    };

    var initializeSpinners = function(element){
        $(element).find(".gf-spinner").spinner({value:0, min: 0, max: 9999});
    };

    var orderAnswers = function(){

        $('[name="comitiumsuite_bundle_cscmsbundle_cspoll"]').on('submit', function(){
            $('[data-hook="gf-portlet"]').each(function(k,v){
                var position_field = $(v).find('[id$="position"]');
                position_field.val(k+1);
            });
        })
    };

    var dragableAnswers = function(){
        $('[data-collection="answer"]').sortable({
            placeholder: 'portlet-sortable-placeholder',
            forcePlaceholderSize: true
        });
    };

    return {
        init: function() {
            addAnswers();
            initializeSpinners('body');
            dragableAnswers();
            orderAnswers();
        },
        validateDeletion: function() {
            var answers = $('[data-hook="gf-portlet"]').toArray();

            return (answers.length != 1);
        }
    };
})();

$(document).ready(function(){
    Pagination.onChange.add(function() {
        $(".popovers").popover();
    });

});