var FormComponents = (function($) {
    'use strict';
    var FormComponents = function(form) {
        this.form = form;
    };

    FormComponents.prototype.initSpinners = function(spinnerSelector, options) {
        spinnerSelector = typeof spinnerSelector === 'undefined' ? '.gf-spinner' : spinnerSelector;
        options = typeof options === 'undefined' ? {} : options;
        $(spinnerSelector).spinner(options);
    };

    FormComponents.prototype.bindAssetWidgetActions = function(selector, options) {
        selector = typeof selector === 'undefined' ? '.cs-selected-assets .opts a' : selector;
        options = typeof options === 'undefined' ? {} : options;

        $(document).on("click", selector, function(e){

            var _this = $(this);
            var isEditButton = _this.hasClass("blue");
            var reloadDropZone = false;
            var idContent = _this.parents("[data-id-content]");
            var container = _this.parents("[id$=_container]");
            var unselectButton = _this.next();
            var isGallery = /galleries/.test(location.href);

            //if (isGallery) {
            //    var v = "|" + idContent.data("id-content");
            //    var galleryValue =  $('[value$="'+v+'"]').val();
            //}

            var isImage = container.data("dropzoneElement").data("dropzoneType") === "image";

            if (isEditButton /*&& isImage*/) {

                e.preventDefault();

                var url = ComitiumUtils.addURLParameter(_this.attr("href"), "forIframe", 1);

                if ($('#dialog')) {
                    $('#dialog').remove();
                }

                var modal = $('<div class="modal-backdrop show"></div>')
                    .attr({
                        "id":"cs-modal-crops",
                        "class": 'modal show',
                        "aria-modal": "true",
                        "tabindex": "10051",
                    })
                    .load(Routing.generate('designer_asset_crops_index', {assetId: idContent.data("id-content")}), function () {
                        window.parent.$("body").append(modal);

                        modal.on('hidden.bs.modal', function () {
                            modal.remove();
                            ImageCrop.jcropApi = null;
                        });

                        $('[data-dismiss]', modal).on("click", function () {
                            modal.remove();
                            ImageCrop.jcropApi = null;
                        });

                        modal.show();

                        ImageCrop.init(
                            [parseInt(idContent.data("width")), parseInt(idContent.data("height"))],
                            idContent.data("id-content"),
                            window.parent.$("body")
                        );
                    })
                    .modal({
                        show: false
                    });

                /*
                $.ajax(Routing.generate('designer_asset_crops_index'), {
                    success: function (data) {
                        // var dialog = '<div id="dialog"><iframe id="dialogIframe" src="'+url+'" width="100%" height="100%"></iframe></div>';
                        var dialog = $(data).modal();

                        $("body").append(dialog);

                        $("#dialog" ).dialog({
                            autoOpen: true,
                            width: 975,
                            height: 975,
                            modal: true,
                            resizable: false,
                            close: function(event,ui){
                                if (reloadDropZone === true && !isGallery && isImage) {
                                    setTimeout(function() {
                                        if (unselectButton.is('[data-action="unselect"]')) {
                                            unselectButton.trigger('click');
                                            if (container.length > 0 && idContent.length > 0 ) {
                                                AssetsHelper.loadById(container, idContent.data("id-content"), function(widget, element){
                                                    //if (isGallery) {
                                                    //    element.addClass("portlet portlet-sortable");
                                                    //    $('[data-asset][value="'+idContent.data("id-content")+'"]').val(galleryValue);
                                                    //    Gallery.initWidget(container, AssetAdvancedFilter);
                                                    //    PortletDraggable.init();
                                                    //}
                                                });
                                            }
                                        }
                                    }, 1000);
                                }

                                $('form button[type="submit"]').removeClass("disabled");
                                $(window).trigger('cs:assetsEditClose');
                            },
                            open: function(event, iu) {
                                $(window).trigger('cs:assetsEditOpen');
                            }
                        });
                    }
                });

                $('#dialogIframe').load(function() {
                    var frame = document.getElementById('dialogIframe');

                    window.addEventListener("message", function (event) {
                        if (event.data === true) {
                            reloadDropZone = true;
                            $("#dialog").dialog("close");
                        }
                    }, false);

                    frame.contentWindow.postMessage("cs.assets.edit.submit", url);
                });
                */
            }
        });
    };

    return FormComponents;
}(window.jQuery));
