var CsRelatedContent = function(locale){
    this.modal = {
        id: 'cs-related-content',
        html: '',
        options: {},
        searchInput: {},
        resultsContainer: {}
    };

    this.locale = locale;

    this.callBack = {};
};

CsRelatedContent.prototype.createModal = function(callBack) {

    var _this = this;

    this.modal.html = $('<div></div>')
        .attr({
            "id":this.modal.id,
            "class": 'modal fade bs-modal-lg',
            "tabindex": "-1",
            "role": "dialog",
            "aria-labelledby": "myModalLabel1",
            "aria-hidden": "true"
        })
        .load(Routing.generate('cs_core_ck_related_content_index'), function(){
            _this.signals.onModalContentLoaded.dispatch();
        })
        .modal({
            show: false
        });

    $('body').append(this.modal.html);

    this.modal.html.on('hidden.bs.modal', function () {
        _this.destroyModal();
    });

    this.signals.onModalCreated.dispatch();

    this.showModal();

    callBack.call(this,this);
};


CsRelatedContent.prototype.showModal = function() {
    this.modal.html.modal().show();
};

CsRelatedContent.prototype.destroyModal = function() {
    this.signals.onDestroyModal.dispatch();
    this.reset();
};

CsRelatedContent.prototype.bind = function () {
    var entity = null;
    var _this = this;

    this.signals.onModalContentLoaded.add(function () {
        var entityInputSearch = new EntityInputSearch(
            _this.modal.html.find("#link-search-input"),
            _this.modal.html.find("#search-order"),
            _this.modal.html.find("#link-search-results"),
            _this.locale,
            {
                types: "102,104,113",
                existUrl: false
            }
        );

        entityInputSearch.handlers.onFetchLink.add(function (data, item) {
            _this.modal.html.find("#link-search-input").val(item.title);
            _this.modal.html.find("#clear-link").show();
            _this.modal.html.find("#search-order").hide();
            _this.modal.html.find("#link-search-input").prop("disabled", true);
            _this.modal.html.find("#link-submit").prop("disabled", false);

            if (item._type === "galleries") {
                _this.modal.html.find("#search-orientation-label").show();
                _this.modal.html.find("#search-orientation").show();
            }

            entity = item;
        });

        entityInputSearch.bindSearch();

        _this.modal.html.on("click", "[data-action='fetch-link']", function () {
            var object = $(this).parents("tr").data("object");

            entityInputSearch.fetchLink(object, function () {
                entityInputSearch.hideResults();
            });
        });

        _this.modal.html.find("#clear-link").on("click", function () {
            entity = null;
            _this.modal.html.find("#link-search-input")
                .prop("disabled", false)
                .val("");
            _this.modal.html.find("#clear-link").hide();
            _this.modal.html.find("#link-submit").prop("disabled", true);
            _this.modal.html.find("#search-order").show();
            _this.modal.html.find("#search-orientation-label").hide();
            _this.modal.html.find("#search-orientation").hide();
        });

        _this.modal.html.find("#link-submit").on("click", function () {
            if (entity._type === "galleries") {
                entity.orientation = _this.modal.html.find("#search-orientation").val();
            }

            _this.signals.onSubmit.dispatch(entity);
            _this.destroyModal();
        });
    });
};

CsRelatedContent.prototype.signals = {
    onModalCreated: new signals.Signal(),
    onDestroyModal: new signals.Signal(),
    onModalContentLoaded: new signals.Signal(),
    onSubmit: new signals.Signal(),
};

CsRelatedContent.prototype.reset = function () {
    var _this = this;

    $.each(_this.signals, function (k, v) {
        v.removeAll();
    });
};
