var DateRangePicker = (function() {

    var _this = this;
    this.defaultRanges = {};

    this.onDateSelected = new signals.Signal();

    this.defaultInitDates = {
        today: moment(),
        yesterday: moment().subtract(1,'day'),
        sevenDaysAgo: moment().subtract(7, 'days'),
        oneMonthAgo: moment().subtract(1, 'month')
    };

    this.rangeTitle = {
        today: Translator.trans("cs_core.datepicker.time_periods.today"),
        yesterday: Translator.trans("cs_core.datepicker.time_periods.yesterday"),
        lastWeek: Translator.trans("cs_core.datepicker.time_periods.lastweek"),
        lastMonth: Translator.trans("cs_core.datepicker.time_periods.lastmonth"),
        last7days: Translator.trans("cs_core.datepicker.time_periods.last7days"),
        last30days: Translator.trans("cs_core.datepicker.time_periods.last30days")
    };

    this.default_options = {
        "showDropdowns": true,
        "locale": {
            "format": "DD/MM/YYYY",
            "separator": " - ",
            "applyLabel": Translator.trans("cs_core.action.apply.default"),
            "cancelLabel": Translator.trans("cs_core.action.cancel.default"),
            "fromLabel": Translator.trans("cs_core.datepicker.from"),
            "toLabel": Translator.trans("cs_core.datepicker.to"),
            "customRangeLabel": Translator.trans("cs_core.datepicker.time_periods.custom"),
            "daysOfWeek": [
                Translator.trans("cs_core.week_days.monday"),
                Translator.trans("cs_core.week_days.tuesday"),
                Translator.trans("cs_core.week_days.wednesday"),
                Translator.trans("cs_core.week_days.thursday"),
                Translator.trans("cs_core.week_days.friday"),
                Translator.trans("cs_core.week_days.saturday"),
                Translator.trans("cs_core.week_days.sunday")
            ],
            "monthNames": [
                Translator.trans("cs_core.months.january"),
                Translator.trans("cs_core.months.february"),
                Translator.trans("cs_core.months.march"),
                Translator.trans("cs_core.months.april"),
                Translator.trans("cs_core.months.may"),
                Translator.trans("cs_core.months.june"),
                Translator.trans("cs_core.months.july"),
                Translator.trans("cs_core.months.august"),
                Translator.trans("cs_core.months.september"),
                Translator.trans("cs_core.months.october"),
                Translator.trans("cs_core.months.november"),
                Translator.trans("cs_core.months.december")
            ],
            "firstDay": 1
        },
        "opens": "left"
    };

    this.defaultRanges[this.rangeTitle.today] = [
        this.defaultInitDates.today.format("DD/MM/YYYY"),
        this.defaultInitDates.today.format("DD/MM/YYYY")
    ];

    this.defaultRanges[this.rangeTitle.yesterday] = [
        this.defaultInitDates.yesterday.format("DD/MM/YYYY"),
        this.defaultInitDates.yesterday.format("DD/MM/YYYY")
    ];

    this.defaultRanges[this.rangeTitle.lastWeek] = [
        this.defaultInitDates.sevenDaysAgo.clone().startOf('isoweek').format("DD/MM/YYYY"),
        this.defaultInitDates.sevenDaysAgo.clone().endOf('isoweek').format("DD/MM/YYYY")
    ];

    this.defaultRanges[this.rangeTitle.lastMonth] = [
        this.defaultInitDates.oneMonthAgo.clone().startOf('month').format("DD/MM/YYYY"),
        this.defaultInitDates.oneMonthAgo.clone().endOf('month').format("DD/MM/YYYY")
    ];

    this.defaultRanges[this.rangeTitle.last7days] = [
        this.defaultInitDates.sevenDaysAgo.format("DD/MM/YYYY"),
        this.defaultInitDates.yesterday.format("DD/MM/YYYY")
    ];

    this.defaultRanges[this.rangeTitle.last30days] = [
        this.defaultInitDates.oneMonthAgo.format("DD/MM/YYYY"),
        this.defaultInitDates.yesterday.format("DD/MM/YYYY")
    ];

    this.default_options.ranges = this.defaultRanges;

    return {
            init: function(selector, callback, options){

                if (typeof options === "object") {
                    $.extend(_this.default_options, options)
                }

                $(selector).daterangepicker(_this.default_options, function(start, end, label) {
                    if (typeof callback === "function") {
                        callback.call(this, start, end, label, selector);
                    } else {
                        _this.onDateSelected.dispatch(start, end, label, selector);
                    }
                });
            },
            setOptions: function(options){
                $.extend(_this.default_options, options)
            },
            onDateChange: function(action,listener, listenerContext){
                _this.onDateSelected[action](listener, listenerContext);
            },
            getRangeTitle: function(title){
                if(title == 'custom'){
                    return _this.default_options.customRangeLabel;
                }else{
                    if(title in _this.rangeTitle){
                        return _this.rangeTitle[title];
                    }else{
                        return '';
                    }
                }
            }
        }
}.call({}));