/**
 * Activity class, all activity classes must inherit from this prototype
 * @constructor
 */

var Activity = function() {
    this.signals = {};
};

/**
 * Initializes the activity
 */
Activity.prototype.init = function() {};

/**
 * Calls the activity
 */
Activity.prototype.call = function() {};

/**
 *
 * @param signal
 * @param listener
 * @returns {Activity}
 */
Activity.prototype.on = function(signal, listener) {

    if(this.signals.hasOwnProperty(signal) && typeof listener == 'function') {
        this.signals[signal].add(listener);
        return this;
    }

    throw new Error('The signal ' + signal + ' does not exists or listener is not a function');
};