CKEDITOR.plugins.add( "csrelatedcontent", {
    icons: "csrelatedcontent",
    init: function( editor ) {
        editor.csRelatedContent = new CsRelatedContent(editor.element.$.lang);

        editor.addCommand( "insertRelatedContent", {
            exec: function( editor ) {
                editor.csRelatedContent.bind();

                editor.csRelatedContent.createModal(function () {});

                editor.csRelatedContent.signals.onSubmit.add(function (entity) {
                    var element = editor.document.createElement("div"),
                        orientation = typeof entity.orientation === "undefined" ? "" : entity.orientation + ":";

                    element.setAttribute("class", ("cke-element cke-element--"+ entity.entityType));

                    element.setText("["+entity._type+":"+orientation+entity.id+"]");

                    editor.insertElement(element);
                });
            }
        });

        editor.ui.addButton( "CsRelatedContent", {
            label: Translator.trans('cs_core.cs_relatedcontent.label'),
            command: "insertRelatedContent",
            toolbar: "csrelatedcontent"
        });
    }
});
