CKEDITOR.plugins.add('cslinks', {
    init: function(editor) {
        delete editor._.menuItems.link;
        editor.cslink = CsLinks.init();

        editor.cslink.setLocale(editor.element.$.lang);

        var command = new CKEDITOR.command( editor, {
            exec: function( editor ) {

                _initEvents();

                var selectedElement  = editor.getSelection().getSelectedElement();

                if (!selectedElement) {
                    selectedElement = editor.getSelection().getSelectedText();
                }

                var link = _buildLink(CKEDITOR.plugins.link.getSelectedLink(editor));

                editor.cslink.exec(link, function(element){
                    _createElement(element, selectedElement);
                });
            }
        } );

        var _createElement = function(element, selectedElement){

            var e = editor.document.createElement( 'a');

            e.setAttribute('href', element.link.href);
            if (element.link.sponsored === "sponsored") {
                element.link.rel += " " + element.link.sponsored;
            }

            e.setAttribute('rel',element.link.rel);
            e.setAttribute('target',element.link.target);
            e.setAttribute('data-external', element.link.external);

            for (var key in element.link.intl) {
                if (element.link.intl.hasOwnProperty(key)) {
                    e.setAttribute('data-intl-links-' + key, element.link.intl[key]);
                }
            }

            if (typeof  selectedElement === "string") {
                e.setAttribute('title',element.link.title ? element.link.title: selectedElement ? selectedElement : element.link.href);
                e.setText(selectedElement ? selectedElement : element.link.href);
            } else {
                e.setAttribute('title', selectedElement.$.title);
                selectedElement.appendTo(e);
            }

            editor.insertElement( e );
        };

        var _buildLink = function(element) {
            var link  = editor.cslink.createLink();

            if (!element) {
                return link;
            }

            if (element.getAttribute('href')) {
                link.href = element.getAttribute('href');
            }
            if (element.getAttribute('title')) {
                link.title = element.getAttribute('title');
            }
            if (element.getAttribute('rel')) {
                var relString = element.getAttribute("rel");
                if (relString.indexOf("sponsored") !== -1) {
                    link.sponsored = relString.substring(relString.indexOf("sponsored"));
                } else {
                    link.sponsored = "";
                }
                link.rel = relString.replace(" sponsored", "");
            }

            if (element.getAttribute('target')) {
                link.target = element.getAttribute('target');
            }
            if (element.getAttribute('data-external')) {
                link.external = element.getAttribute('data-external');
            } else {
                link.external = 1;
            }

            return link;
        };

        var _initEvents = function() {

            editor.focusManager.lock();

            editor.cslink.signals.onDestroyModal.add(function(){
                editor.focusManager.unlock();
            });
        };

        editor.addCommand( 'cslinks', command);

        editor.ui.addButton( 'CsLink', {
            label: Translator.trans('cs_core.links.modal.title'),
            command: 'cslinks',
            toolbar: 'links',
            icon: this.path + 'icons/cslinks.png'
        });

        editor.keystrokeHandler.keystrokes[CKEDITOR.CTRL + 76] = 'cslinks';


        editor.on('doubleclick', function( evt ) {
            var element = evt.data.element;
            if ( !element.isReadOnly() ) {
                if (element.is('a')) {

                    _initEvents();

                    // Prevent to show default link dialog
                    //evt.data.$.preventDefault();
                    evt.data.dialog = null;

                    var link = _buildLink(element);
                    var text = editor.getSelection().getSelectedText();

                    editor.cslink.exec(link, function(element){
                        _createElement(element, text);
                    });
                }
            }
        },null,null,1);

    }
});
