<?php

namespace Comitium5\DesignerBundle\Publisher\Widget;

use Comitium5\DesignerBundle\Helper\Widget\WidgetHelper;
use Comitium5\DesignerBundle\Model\Interfaces\Widget\AbstractDesignerWidgetControllerInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Widget\WidgetInterface;

/**
 * Class WidgetBuilder
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Publisher\Widget
 */
class WidgetBuilder
{
    /**
     * @var WidgetHelper
     */
    private $widgetHelper;

    /**
     * @var string
     */
    private $bundlePath;

    /**
     * @param $container
     * @param WidgetHelper $widgetHelper
     * @param $bundlePath
     */
    public function __construct($container, WidgetHelper $widgetHelper, $bundlePath)
    {
        $this->container = $container;
        $this->widgetHelper = $widgetHelper;
        $this->bundlePath = $bundlePath;
    }

    /**
     * @param WidgetInterface $widget
     *
     * @return AbstractDesignerWidgetControllerInterface
     */
    public function buildWidgetController(WidgetInterface $widget)
    {
        try {
            $controller = $widget->getControllerInstance();
            $controller->setWidgetHelper($this->widgetHelper);
            $controller->setBundlePath($this->bundlePath);
            $controller->setContainer($this->container);

            return $controller;
        } catch (\Exception $e) {
            return null;
        }
    }

    /**
     * @return WidgetHelper
     */
    public function getWidgetHelper()
    {
        return $this->widgetHelper;
    }

    /**
     * @param WidgetHelper $widgetHelper
     */
    public function setWidgetHelper(WidgetHelper $widgetHelper)
    {
        $this->widgetHelper = $widgetHelper;
    }
}
