<?php

namespace Comitium5\DesignerBundle\Provider\Subsite;

use Comitium5\ApiClientBundle\Client\ClientInterface;
use Comitium5\ApiClientBundle\Client\Services\SubsiteApiService;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\DesignerBundle\Factory\CollectionNormalizerFactory;
use Comitium5\DesignerBundle\Factory\Subsite\SubsiteFactory;
use Comitium5\DesignerBundle\Model\Interfaces\Subsite\SubsiteInterface;

/**
 * Class MultipleSubsiteProvider
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\Provider\Subsite
 */
class MultipleSubsiteProvider
{
    /**
     * @var CollectionNormalizerFactory
     */
    private $normalizerFactory;

    /**
     * @var SubsiteInterface[]
     */
    private $subsites;

    /**
     * SubsiteProvider constructor.
     *
     * @param ClientInterface $apiClient
     */
    public function __construct(ClientInterface $apiClient)
    {
        $this->subsites = [];
        $this->normalizerFactory = new CollectionNormalizerFactory(
            new SubsiteApiService($apiClient),
            new SubsiteFactory()
        );
    }

    /**
     * @return array|SubsiteInterface[]
     * @throws \Exception
     */
    public function getSubsites(): array
    {
        $this->subsites = $this
            ->normalizerFactory
            ->create(new ParametersValue([]));

        return $this->subsites;
    }
}