<?php

namespace Comitium5\DesignerBundle\Normalizer\Api\Asset;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\DesignerBundle\Normalizer\Api\ApiNormalizerInterface;

/**
 * Class AssetImageRelatedNormalizer
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Normalizer\Api\Asset
 */
class AssetImageRelatedNormalizer implements ApiNormalizerInterface
{
    /**
     * @var AssetApiService
     */
    protected $assetApiService;

    /**
     * AssetImageRelatedNormalizer constructor.
     *
     * @param AssetApiService $assetApiService
     */
    public function __construct(AssetApiService $assetApiService)
    {
        $this->assetApiService = $assetApiService;
    }

    /**
     * @param array $entity
     *
     * @return array
     * @throws \Exception
     */
    public function normalize(array $entity): array
    {
        if (isset($entity["imageRelated"]["id"])) {
            $entity["imageRelated"] = $this
                ->assetApiService
                ->find(new IdentifiedValue($entity["imageRelated"]["id"]));
        }

        return $entity;
    }
}
