<?php

namespace Comitium5\DesignerBundle\Model\Traits\Layout;


use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageWidgetInterface;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Trait LayoutPageWidgetCollectionTrait
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits\Layout
 */
trait LayoutPageWidgetCollectionTrait
{
	/**
	 * @var ArrayCollection
	 */
	protected $layoutPageWidgets;

	/**
	 * @param LayoutPageWidgetInterface $layoutPageWidget
	 * @return self
	 */
	public function addLayoutPageWidget(LayoutPageWidgetInterface $layoutPageWidget)
	{
		if (!$this->layoutPageWidgets->contains($layoutPageWidget)) {
			$layoutPageWidget->setLayoutPage($this);
			$this->layoutPageWidgets->add($layoutPageWidget);
		}
		return $this;
	}

	/**
	 * @param LayoutPageWidgetInterface $layoutPageWidget
	 * @return self
	 */
	public function removeLayoutPageWidget(LayoutPageWidgetInterface $layoutPageWidget)
	{
		$this->layoutPageWidgets->removeElement($layoutPageWidget);
		return $this;
	}

	/**
	 * @return ArrayCollection
	 */
	public function getLayoutPageWidgets()
	{
		return $this->layoutPageWidgets;
	}
	
	/**
	 * @param ArrayCollection $layoutPageWidgets
	 * @return self
	 */
	public function setLayoutPageWidgets(ArrayCollection $layoutPageWidgets)
	{
		$this->layoutPageWidgets = $layoutPageWidgets;
		return $this;
	}
}