<?php

namespace Comitium5\DesignerBundle\Model\Traits\Layout;


use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutInterface;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Trait LayoutCollectionTrait
 * 
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits\Layout
 */
trait LayoutCollectionTrait
{
	/**
	 * @var ArrayCollection
	 */
	protected $layouts;

	/**
	 * @param LayoutInterface $layout
	 * @return self
	 */
	public function addLayout(LayoutInterface $layout)
	{
		if (!$this->layouts->contains($layout)) {
			$this->layouts->add($layout);
		}

		return $this;
	}

	/**
	 * @param LayoutInterface $layout
	 * @return self
	 */
	public function removeLayout(LayoutInterface $layout)
	{
		$this->layouts->removeElement($layout);
		return $this;
	}

	/**
	 * @return ArrayCollection
	 */
	public function getLayouts()
	{
		return $this->layouts;
	}

	/**
	 * @param ArrayCollection $layouts
	 * @return self
	 */
	public function setLayouts(ArrayCollection $layouts)
	{
		$this->layouts = $layouts;
		return $this;
	}
}