<?php

namespace Comitium5\DesignerBundle\Model\Traits\Layout;


use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutBreakpointInterface;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Trait LayoutBreakpointCollectionTrait
 * 
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits\Layout
 */
trait LayoutBreakpointCollectionTrait
{
	/**
	 * @var ArrayCollection
	 */
	protected $layoutBreakpoints;

	/**
	 * @param LayoutBreakpointInterface $layoutBreakpoint
	 * @return self
	 */
	public function addLayoutBreakpoint(LayoutBreakpointInterface $layoutBreakpoint)
	{
		if (!$this->layoutBreakpoints->contains($layoutBreakpoint)) {
			$layoutBreakpoint->setLayout($this);
			$this->layoutBreakpoints->add($layoutBreakpoint);
		}

		return $this;
	}

	/**
	 * @param LayoutBreakpointInterface $layoutBreakpoint
	 * @return self
	 */
	public function removeLayoutBreakpoint(LayoutBreakpointInterface $layoutBreakpoint)
	{
		$this->layoutBreakpoints->removeElement($layoutBreakpoint);
		return $this;
	}

	/**
	 * @return ArrayCollection
	 */
	public function getLayoutBreakpoints()
	{
		return $this->layoutBreakpoints;
	}

	/**
	 * @param ArrayCollection $layoutBreakpoints
	 * @return self
	 */
	public function setLayoutBreakpoints(ArrayCollection $layoutBreakpoints)
	{
		$this->layoutBreakpoints = $layoutBreakpoints;
		return $this;
	}
}