<?php

namespace Comitium5\DesignerBundle\Model\Traits;

use Comitium5\DesignerBundle\Model\Interfaces\EnabledInterface;

/**
 * Trait EnabledTrait
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait EnabledTrait
{
    /**
     * @var bool|null
     */
    protected $enabled;

    /**
     * @param bool|null $enabled
     *
     * @return $this|EnabledInterface
     */
    public function setEnabled(bool $enabled = null): EnabledInterface
    {
        $this->enabled = $enabled;

        return $this;
    }

    /**
     * @return bool|null
     */
    public function getEnabled(): ?bool
    {
        return $this->enabled;
    }

    /**
     * @return bool|null
     */
    public function isEnabled(): ?bool
    {
        return $this->enabled;
    }
}