<?php

namespace Comitium5\DesignerBundle\Model\Traits;

use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;

/**
 * Class DateTimeTrait
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait DateTimeTrait
{
    /**
     * @var \DateTime|null
     */
    protected $createdAt;

    /**
     * @var \DateTime|null
     */
    protected $updatedAt;

    /**
     * @param \DateTime $date
     *
     * @return $this|DateTimeInterface
     */
    public function setCreatedAt(\DateTime $date): DateTimeInterface
    {
        $this->createdAt = $date;

        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getCreatedAt(): ?\DateTime
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $date
     *
     * @return $this|DateTimeInterface
     */
    public function setUpdatedAt(\DateTime $date): DateTimeInterface
    {
        $this->updatedAt = $date;

        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getUpdatedAt(): ?\DateTime
    {
        return $this->updatedAt;
    }
}
