<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Widget;

use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\HttpFoundation\File\File;

/**
 * Interface WidgetInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Widget
 */
interface WidgetInterface extends DateTimeInterface
{
    /**
     * @param $title
     * @return mixed
     */
    public function setTitle($title);

    /**
     * @return mixed
     */
    public function getTitle();

    /**
     * @param WidgetGroupInterface $group
     *
     * @return mixed
     */
    public function setGroup(WidgetGroupInterface $group);

    /**
     * @return mixed
     */
    public function getGroup();

    /**
     * @return mixed
     */
    public function getName();

    /**
     * @param string $name
     *
     * @return mixed
     */
    public function setName($name);

    /**
     * @return mixed
     */
    public function getDescription();

    /**
     * @param $description
     *
     * @return mixed
     */
    public function setDescription($description);

    /**
     * @return mixed
     */
    public function getVersion();

    /**
     * @param $version
     *
     * @return mixed
     */
    public function setVersion($version);

    /**
     * @return mixed
     */
    public function getType();

    /**
     * @param $type
     *
     * @return mixed
     */
    public function setType($type);

    /**
     * @return mixed
     */
    public function getSource();

    /**
     * @param $source
     *
     * @return mixed
     */
    public function setSource($source);

    /**
     * @return mixed
     */
    public function getControllerNameSpace();

    /**
     * @return AbstractDesignerWidgetControllerInterface
     */
    public function getControllerInstance();

    /**
     * @param bool $asNameSpace
     *
     * @return mixed
     */
    public function getFolderPath($asNameSpace = true);

    /**
     * @param bool $asNameSpace
     *
     * @return mixed
     */
    public function buildFolderName($asNameSpace = true);

    /**
     * @return mixed
     */
    public function formatName();

    /**
     * @param $option
     *
     * @return mixed
     */
    public function addOption($option);

    /**
     * @param $option
     *
     * @return mixed
     */
    public function removeOption($option);

    /**
     * @param ArrayCollection $options
     *
     * @return mixed
     */
    public function setOptions(ArrayCollection $options);

    /**
     * @return mixed
     */
    public function getOptions();

    /**
     * @param File $file
     *
     * @return mixed
     */
    public function setFile(File $file);

    /**
     * @return mixed
     */
    public function getFile();
}
