<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Widget;

use Comitium5\DesignerBundle\Helper\Widget\WidgetHelper;

/**
 * Interface AbstractDesignerWidgetControllerInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Widget
 */
interface AbstractDesignerWidgetControllerInterface
{
    /**
     * @param array $parameters
     *
     * @return mixed
     */
    public function renderAction(array $parameters = []);

    /**
     * @param array $parameters
     * @return mixed
     */
    //    public function resolveData(array $parameters = []);

    /**
     *
     * @return mixed
     */
    public function renderCached();

    /**
     * @return mixed
     */
    public function getConfigParameters();

    /**
     * @return mixed
     */
    public function getCssResourcesPaths();

    /**
     * @return mixed
     */
    public function getJsResourcesPaths();

    /**
     * @return mixed
     */
    public function getIconPaths();

    /**
     * @param WidgetHelper $widgetHelper
     *
     * @return mixed
     */
    public function setWidgetHelper(WidgetHelper $widgetHelper);

    /**
     * @return mixed
     */
    public function getWidgetHelper();

    /**
     * @param $bundlePath
     *
     * @return mixed
     */
    public function setBundlePath($bundlePath);

    /**
     * @return mixed
     */
    public function getBundlePath();
}
