<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Template;

use Comitium5\DesignerBundle\Model\Interfaces\Breakpoint\BreakpointCollectionInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Css\CssCollectionInterface;
use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\EnabledInterface;
use Comitium5\DesignerBundle\Model\Interfaces\HierarchicalInterface;
use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutCollectionInterface;
use Comitium5\DesignerBundle\Model\Interfaces\LibraryJS\LibraryJSCollectionInterface;
use Comitium5\DesignerBundle\Model\Interfaces\PublishDateInterface;
use Comitium5\DesignerBundle\Model\Interfaces\SortableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\TmpIdentifierInterface;
use Comitium5\DesignerBundle\Model\Interfaces\View\ViewCollectionInterface;

/**
 * Interface TemplateInterface
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Template
 */
interface TemplateInterface extends
    DateTimeInterface,
    EnabledInterface,
    HierarchicalInterface,
    PublishDateInterface,
    LayoutCollectionInterface,
    BreakpointCollectionInterface,
    CssCollectionInterface,
    LibraryJSCollectionInterface,
    SortableInterface,
    IdentifiableInterface,
    TmpIdentifierInterface,
    ViewCollectionInterface
{
    /**
     * @return mixed
     */
    public function getName();

    /**
     * @param $name
     *
     * @return mixed
     */
    public function setName($name);

    /**
     * @return mixed
     */
    public function getDescription();

    /**
     * @param $description
     *
     * @return mixed
     */
    public function setDescription($description);

    /**
     * @return mixed
     */
    public function getType();

    /**
     * @param $type
     *
     * @return mixed
     */
    public function setType($type);

    /**
     * @param  bool $parent (optional)
     * @return mixed
     */
    public function getWidth($parent = false);

    /**
     * @param $width
     *
     * @return mixed
     */
    public function setWidth($width);

    /**
     * @param  bool $parent (optional)
     * @return mixed
     */
    public function getColumns($parent = false);

    /**
     * @param $columns
     *
     * @return mixed
     */
    public function setColumns($columns);

    /**
     * @param  bool $parent (optional)
     * @return mixed
     */
    public function getGutterWidth($parent = false);

    /**
     * @param $gutterWidth
     *
     * @return mixed
     */
    public function setGutterWidth($gutterWidth);

    /**
     * @return mixed
     */
    public function getColor();

    /**
     * @param $color
     *
     * @return mixed
     */
    public function setColor($color);

    /**
     * @param bool $temporary (optional)
     * @return string
     */
    public function getFilePath($temporary = false);

    /**
     * @param $useBootstrapRows
     * @return mixed
     */
    public function setUseBootstrapRows($useBootstrapRows);

    /**
     * @return mixed
     */
    public function isUseBootstrapRows();

    /**
     * @return bool
     */
    public function isAllowedToGenerateTemplate();
}
