<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Subsite;

use Comitium5\DesignerBundle\Entity\Locale;
use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Site\SiteInterface;

/**
 * Interface SubsiteInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Subsite
 */
interface SubsiteInterface extends IdentifiableInterface, DateTimeInterface
{
    /**
     * @return string
     */
    public function getLocale();

    /**
     * @param string $locale
     *
     * @return $this
     */
    public function setLocale($locale);

    /**
     * @return string
     */
    public function getName();

    /**
     * @param string $name
     *
     * @return $this
     */
    public function setName($name);

    /**
     * @return string
     */
    public function getDescription();

    /**
     * @param string $description
     *
     * @return $this
     */
    public function setDescription($description);

    /**
     * @return string
     */
    public function getDomain();

    /**
     * @param string $domain
     *
     * @return $this
     */
    public function setDomain($domain);

    /**
     * @return string
     */
    public function getAcronym();

    /**
     * @param string $acronym
     *
     * @return $this
     */
    public function setAcronym($acronym);

    /**
     * @return bool
     */
    public function isDefault();

    /**
     * @param bool $isDefault
     *
     * @return $this
     */
    public function setIsDefault($isDefault);

    /**
     * @return Locale[]
     */
    public function getLocaleDomains(): array;

    /**
     * @param array $localeDomains
     *
     * @return $this
     */
    public function setLocaleDomains(array $localeDomains);

    /**
     * @return string
     */
    public function getColor();

    /**
     * @param string $color
     *
     * @return $this
     */
    public function setColor($color);

    /**
     * @return SiteInterface
     */
    public function getSite();

    /**
     * @param $site
     *
     * @return $this
     */
    public function setSite($site);

    /**
     * @return array
     */
    public function getConfig(): array;

    /**
     * @param array $config
     *
     * @return $this
     */
    public function setConfig(array $config);
}
