<?php


namespace Comitium5\DesignerBundle\Model\Interfaces\State;

use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\SortableInterface;

/**
 * Interface StateInterface
 * @author Fernando Pradas <fernando@bab-soft.com>
 */
interface StateInterface extends SortableInterface, IdentifiableInterface
{
    /**
     * @return string
     */
    public function getName();

    /**
     * @param string $name
     */
    public function setName($name);

    /**
     * @return mixed
     */
    public function getBehaviours();

    /**
     * @param StateBehaviourInterface $behaviour
     * @return mixed
     */
    public function addBehaviour(StateBehaviourInterface $behaviour);

    /**
     * @param StateBehaviourInterface $behaviour
     * @return mixed
     */
    public function removeBehaviour(StateBehaviourInterface $behaviour);

    /**
     * @return mixed
     */
    public function getWorkflow();

    /**
     * @param mixed $workflow
     */
    public function setWorkflow(WorkflowInterface $workflow);
}