<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Node;

use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;
use Doctrine\Common\Collections\ArrayCollection;


/**
 * Interface NodeInterface
 * @author Fernando Pradas <fernando@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces
 */
interface NodeInterface extends \Iterator, IdentifiableInterface
{

    /**
     * @param NodeInterface $child
     * @return mixed
     */
    public function addChild(NodeInterface $child);

    /**
     * @param NodeInterface $child
     * @return mixed
     */
    public function removeChild(NodeInterface $child);

    /**
     * @return mixed
     */
    public function getChildren();

    /**
     * @param ArrayCollection $children
     * @return mixed
     */
    public function setChildren(ArrayCollection $children);

    /**
     * @param NodeInterface|null $parent
     * @return mixed
     */
    public function setParent(NodeInterface $parent = null);

    /**
     * @return NodeInterface
     */
    public function getParent();

    /**
     * @return boolean
     */
    public function hasChildren();
}