<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Layout;

use Comitium5\DesignerBundle\Model\Interfaces\Page\PageRelationInterface;
use Comitium5\DesignerBundle\Model\Interfaces\SortableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\TmpIdentifierInterface;

/**
 * Interface LayoutPageInterface
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package  Comitium5\DesignerBundle\Model\Interfaces\Layout
 */
interface LayoutPageInterface extends
    SortableInterface,
    PageRelationInterface,
    LayoutRelationInterface,
    LayoutPageWidgetCollectionInterface,
    TmpIdentifierInterface
{
    /**
     * @return \DateTime
     */
    public function getStartAt();

    /**
     * @param \DateTime $startAt
     * @return self
     */
    public function setStartAt($startAt);

    /**
     * @return \DateTime
     */
    public function getEndAt();

    /**
     * @param \DateTime $endAt
     * @return self
     */
    public function setEndAt($endAt);

	/**
	 * @return string
	 */
	public function getHtml();

    /**
     * @param string $html
     * @return self
     */
	public function setHtml(string $html);
}
