<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Layout;


use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\HierarchicalInterface;
use Comitium5\DesignerBundle\Model\Interfaces\TmpIdentifierInterface;
use Comitium5\DesignerBundle\Model\Interfaces\View\ViewCollectionInterface;

/**
 * Interface LayoutInterface
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Layout
 */
interface LayoutInterface extends
	DateTimeInterface,
	HierarchicalInterface,
	LayoutBreakpointCollectionInterface,
	LayoutPageCollectionInterface,
	LayoutCollectionInterface,
    TmpIdentifierInterface,
    ViewCollectionInterface
{
	/**
	 * @return string
	 */
	public function getName();

    /**
     * @param string $name
     * @return self
     */
	public function setName(string $name);

	/**
	 * @return string
	 */
	public function getClass();

    /**
     * @param string $class
     * @return self
     */
	public function setClass(string $class);

	/**
	 * @return string
	 */
	public function getColor();

    /**
     * @param string $color
     * @return self
     */
	public function setColor(string $color);

	/**
	 * @return bool
	 */
	public function isLocked();

	/**
	 * @return bool
	 */
	public function getLocked();

	/**
	 * @param bool $locked
	 * @return self
	 */
	public function setLocked($locked);

	/**
	 * @return bool
	 */
	public function isLinked();

	/**
	 * @return bool
	 */
	public function getLinked();

	/**
	 * @param bool $linked
	 * @return self
	 */
	public function setLinked($linked);

    /**
     * @return bool
     */
    public function isPredefined();

    /**
     * @return bool
     */
    public function getPredefined();

    /**
     * @param bool $predefined
     * @return self
     */
    public function setPredefined($predefined);

	/**
	 * @return string
	 */
	public function getCss();

	/**
	 * @param string $css
	 * @return self
	 */
	public function setCss($css);
}
