<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Layout;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface LayoutCollectionInterface
 * 
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Layout
 */
interface LayoutCollectionInterface
{
	/**
	 * @param LayoutInterface $layout
	 * @return self
	 */
	public function addLayout(LayoutInterface $layout);

	/**
	 * @param LayoutInterface $layout
	 * @return self
	 */
	public function removeLayout(LayoutInterface $layout);

	/**
	 * @return ArrayCollection
	 */
	public function getLayouts();

	/**
	 * @param ArrayCollection $layouts
	 * @return self
	 */
	public function setLayouts(ArrayCollection $layouts);
}
